( *
  * LANGUAGE    : ANS Forth
  * PROJECT     : Forth Libraries
  * DESCRIPTION : A nano-IRC client
  * CATEGORY    : Utility - check RFC-1459 for more functionality
  * AUTHOR      : Marcel Hendrix 
  * LAST CHANGE : Sunday, December 31, 2006, 14:12 PM, Marcel Hendrix; works for Linux with UTYPE 
  * LAST CHANGE : Saturday, December 30, 2006, 1:46 AM, Marcel Hendrix 
  * LAST CHANGE : Sunday, February 04, 2007, 11:14 AM, gForth port
  * )


	S" itools.frt" INCLUDED

	[DEFINED] -irc [IF] -irc [THEN] MARKER -irc

\  Use socket API functions to perform IRC communication using TCP. 
\  Connect to an (internally specified) IRC server, using predefined 
\  REALNAME, USERNAME, and NICK strings.

\  BUGS: There may be an "echo" when you resume HEAR after a SPEAK (text from other
\        users typed during your absence is echoed prefixed with your nick).

\ -- standard tools --------------------------------------------------------------------------------------------------------

0 VALUE lsocket				\ socket for IRC comms
0 VALUE #resp				\ response size
CREATE  response$ 512 CHARS ALLOT	\ buffers response from server

\ -- Force interpretation of ^M and ^J (so they are the same in Windows and Linux)
: UTYPE		BOUNDS ?DO  I C@ DUP 1 > IF  EMIT  ELSE  DROP  ENDIF  LOOP ; 	( c-addr u -- )
: SEND$		lsocket WRITE-SOCKET ; 						( c-addr u -- )
: CMD		+CR SEND$ ;							( c-addr u -- )
: RECEIVE$	lsocket response$ 512 READ-SOCKET TO #resp DROP ; 		( -- )
: ECHO-ALL 	BEGIN  RECEIVE$ #resp  WHILE  response$ #resp UTYPE  REPEAT ;  	( -- ) 
: .TIMESTAMP 	'[' EMIT (TIMESTAMP) ']' EMIT ;					( -- )

\ --------------------------------------------------------------------------------------------------------------------------

: WAIT-FOR ( c-addr u -- )	
	LOCALS| u c-addr |
	CR BEGIN 
	     RECEIVE$ 
	     response$ #resp UTYPE
	     response$ #resp c-addr u SEARCH NIP NIP
	     KEY? OR
	   UNTIL 
	   KEY? IF  KEY DROP  ENDIF ; 

6667 CONSTANT IPPORT_IRC \ standard IRC port address

CREATE server	," irc.freenode.net"
CREATE username	," mhx"
CREATE realname	," marcel hendrix"
CREATE nick	," ForthIRC"

: .STRIPPED ( c-addr u -- )  
	2DUP S" PRIVMSG #forth :" SEARCH 0= IF  UTYPE 2DROP EXIT  ENDIF
	." <"
	( c-addr u c-addr3 u3 -- ) 2SWAP 1 /STRING  
	BOUNDS ?DO  I C@ '!' = IF LEAVE ENDIF  I C@ EMIT  LOOP 
	." > " 
	( c-addr u -- ) 16 /STRING UTYPE ; 

\ The server may challenge our vitality
: ?TEST-PING ( -- )
	response$ S" PING" TUCK COMPARE 
	0= IF  'O' response$ CHAR+ C! 
		response$ #resp CMD
		0 TO #resp
	ENDIF ; 

: IRC-OPEN ( -- )
	server COUNT IPPORT_IRC OPEN-SERVICE TO lsocket 
	lsocket FALSE BLOCKING-MODE
	500 SET-SOCKET-TIMEOUT
	RECEIVE$ 
	S" NICK " nick COUNT $+ CMD
	S" USER " username COUNT $+ S"  8 * :" $+ realname COUNT $+ CMD 
	S" JOIN #forth" CMD 
	S" :ChanServ!ChanServ@services." WAIT-FOR ;

: IRC-CLOSE ( -- ) 
	S" QUIT :a quit that really quits" 2DUP CMD
	( c-addr u -- ) WAIT-FOR
	2000 SET-SOCKET-TIMEOUT
	lsocket CLOSE-SOCKET ; 

: SPEAK ( -- )
	S" PRIVMSG #forth :" 0 WORD COUNT $+  
	CR ECHO-ALL CMD ; 

: HEAR ( -- )
	CR
	BEGIN 
	  RECEIVE$ 
	  ?TEST-PING
	  #resp IF  .TIMESTAMP SPACE  response$ #resp .STRIPPED  
	      ELSE  100 MS
	     ENDIF
	  KEY?
	UNTIL 
	KEY DROP ;

: .ABOUT CR ." Usage: IRC-OPEN    -- connect to #forth"
	 CR ."        HEAR        -- listen what they say"
	 CR ."        SPEAK text  -- write a message (text) to all on #forth"
	 CR ."        IRC-CLOSE   -- disconnect from #forth" ; 

                .ABOUT CR

				( * End of Source * )