S" itools.frt" 	INCLUDED

 \  Demonstrates using socket API functions to perform email
 \  transmission using the SMTP protocol. Takes four parameters, as
 \  follows:

 \     sendmail "mailserver" "to_addr" "subject" "messagefile.txt"

 \  Connects to the specified mail server, uses to_addr (and an
 \  internally preset from_addr) in the transmitted message header,
 \  then sends real name (internal), subject, repeated To-field and
 \  each line of the messagefile (text file) as the email message
 \  body. Transfer is implemented using the SMTP Internet protocol.


DECIMAL
25 VALUE IPPORT_SMTP			\ SMTP standard port address

CREATE realname ," Marcel Hendrix" 
CREATE msubject 0 C, 256 ALLOT		\ msg subject
CREATE mto      0 C, 256 ALLOT		\ to address
CREATE mfrom    ," mhx@iae.nl"		\ from address
CREATE server	0 C, 256 ALLOT		\ {name | address in dotted notation} of the
					\ server or host system we need to connect to
0  VALUE msocket    
0  VALUE mfile      

: .data-header ( -- c-addr u ) 
	S" From: "        realname COUNT $+
	S"  <"        $+  mfrom    COUNT $+ S" >" $+ +CR
	S" Subject: " $+  msubject COUNT $+ +CR
	S" To: "      $+  mto      COUNT $+ +CR ;

: mail-init ( mailserver-addr&len to-addr&len subject-addr&len filename-addr&len -- )
	R/O BIN OPEN-FILE ?FILE TO mfile
	msubject PLACE
	mto      PLACE
	server   PLACE
	server COUNT IPPORT_SMTP OPEN-SERVICE TO msocket
	msocket TRUE BLOCKING-MODE   ( blocking for mail)
	0 SET-SOCKET-TIMEOUT
	msocket PAD 4096 READ-SOCKET 2DROP ;

: sline ( c-addr u -- )
        +CR 
        msocket WRITE-SOCKET 
        msocket PAD 4096 READ-SOCKET 2DROP ;

: sdata ( c-addr u -- )
        +CR 
        msocket WRITE-SOCKET ;

: helo-server ( -- )  S" HELO "       server COUNT $+  sline ;
: mail-from   ( -- )  S" MAIL FROM: " mfrom  COUNT $+  sline ;
: rcpt-to     ( -- )  S" RCPT TO: "   mto    COUNT $+  sline ;
: data        ( -- )  S" DATA"                         sline ;
: send-quit   ( -- )  S" QUIT"                         sline ;
: mail-exit   ( -- )  mfile CLOSE-FILE DROP  msocket CLOSE-SOCKET ;

: send-file ( -- )
	.data-header sline   \ 2 carriage returns
	BEGIN  PAD DUP 4096 mfile READ-LINE ?FILE 
	WHILE  sdata
	REPEAT 2DROP
	S" " +CR S" ." $+ sline ;

: mail-loop ( -- )  helo-server  mail-from  rcpt-to  data  send-file  send-quit ;
: SENDMAIL ( "server" "to" "subject" "file" -- ) mail-init  mail-loop  mail-exit ;

: .ABOUT  
	CR .` Usage:   "mailserv" "to_addr" "subject" "messagefile" SENDMAIL`
	CR .` Example: S" smtp.chello.nl" S" mhx@iae.nl" S" Send mail works!" S" ./file.txt" SENDMAIL` ;

	.ABOUT CR

