(*
 * LANGUAGE    : ANS Forth
 * PROJECT     : Forth Environments
 * DESCRIPTION : Get e-mail using POP3, RFC-1725
 * CATEGORY    : Utility 
 * AUTHOR      : Marcel Hendrix 
 * LAST CHANGE : Tuesday, December 17, 2002 7:19 PM, Marcel Hendrix 
 * LAST CHANGE : Tuesday, December 24, 2002 8:40 PM, Marcel Hendrix; sstream
 *)


	NEEDS -miscutil
	NEEDS -sstream

	REVISION -mail " Get mail with POP3  Version 1.05 "

	PRIVATES

DOC
(*
   Use socket API functions to perform email transmission using POP3. 
   Connect to an (internally specified) POP3 server, using predefined 
   USER and PASS strings.
*)
ENDDOC

-- standard tools --------------------------------------------------------------------------------------------------------

CREATE eom$		PRIVATE	5 C, ^M C, ^J C, '.' C, ^M C, ^J C,
CREATE tst$		PRIVATE	5 CHARS ALLOT 
0 VALUE file		PRIVATE

SSTREAM [sock]		PRIVATE
CREATE  perr 		PRIVATE	   3 CHARS ALLOT	-- buffers error number from server
CREATE  response$	PRIVATE	#256 CHARS ALLOT	-- buffers response from server
0 VALUE #resp		PRIVATE				-- response size

VARIABLE debug? debug? OFF

: .debug  ( c-addr u -- ) DUP debug? @ AND IF  ^M EMIT '[' EMIT .TIME ." ] " TYPE EXIT  ENDIF 2DROP ;P
: <semit> ( char -- )     DUP EOF = IF  DROP ." <EOF>"  ELSE  EMIT  ENDIF ;P
: ?emit   ( char -- )     debug? @ IF  <semit> EXIT  ENDIF DROP ;P
: FSEND$  ( c-addr u -- ) 0 ?DO  C@+ SPUTCH [sock]  LOOP DROP ;P ( do a timely flush! )
: SEND$   ( c-addr u -- ) FSEND$  SFLUSH [sock] ;P
: CHAR1   ( -- c ) 	  BEGIN  SGETCH [sock] DUP EOF =  WHILE  DROP  REPEAT ;P
: !char	  ( c -- )	  response$ #resp +  C!  #resp 1+ #255 AND TO #resp ;P

: EAT-ALL ( -- )
	CLEAR #resp
	CHAR1 DUP ?emit !char 
	BEGIN  SGETCH [sock] DUP ?emit DUP !char DUP EOF = SWAP ^J = OR  UNTIL ;P

-- Errors are in perr. It is not necessary to translate them.
: .REPORT-ERRORS ( bool -- ) 
	0= ?EXIT
	CR ." Error " perr 3 TYPE  SPACE  response$ #resp TYPE
	TRUE ABORT" protocol error" ;P

: cmd ( c-addr u -- )
	+CR 2DUP .debug SEND$
	CHAR1         DUP ?emit  perr           C!
	SGETCH [sock] DUP ?emit  perr   CHAR+   C!
	SGETCH [sock] DUP ?emit  perr 2 CHARS + C!
	perr C@ '+' <> >S ( should answer +OK, not -ERR )
	 EAT-ALL 
	S> .REPORT-ERRORS ;P 

: $>NUM ( c-addr1 u1 -- c-addr2 u2 u3 )
	BL SKIP  BL Split-At-Char  2SWAP 
	BASE @ >S  DECIMAL  NUMBER?  S> BASE !
	1 <> ABORT" $>num :: invalid number" ;P

: CLEAR-PATTERN ( -- ) tst$ CHAR+ tst$ C@ ERASE ;P

: END? ( char -- )
	tst$ 2+ tst$ 1+ tst$ C@ CMOVE  
	tst$ COUNT + 1- C!
	eom$ COUNT tst$ COUNT COMPARE 0= ;P

: separator ( c-addr u -- )
	$CR COUNT    S"  ---------------*----------------- " $+ 
	2SWAP $+     S"  ---------------*----------------- " $+ 
	+CR +CR file WRITE-FILE ?FILE ;P

: store-it ( c-addr u -- )
	0 LOCAL p
	separator
	CLEAR-PATTERN
	BEGIN
	  SGETCH [sock] 
	  DUP PAD p + C!  1 +TO p
	  p #4096 > IF  PAD p file WRITE-FILE ?FILE CLEAR p  ENDIF
	  END?
	UNTIL
	PAD p file WRITE-FILE ?FILE ;P

-- -----------------------------------------------------------------------------------------------------------------------

 #110 =: IPPORT_POP3	PRIVATE			-- standard POP3 port address

CREATE server		PRIVATE ," pop3.IAEhv.nl"
CREATE mailfile		PRIVATE ," ./idata/email.dat"
CREATE username		PRIVATE ," mhx"
CREATE passwd		PRIVATE #256 CHARS ALLOT  

	S" ./idata/password.cfg" INCLUDED 

: open-mailfile ( -- )
	mailfile COUNT R/W BIN OPEN-FILE ?FILE TO file
	file FILE-SIZE ?FILE 	( move to eof )
	file REPOSITION-FILE ?FILE ;P

: close-mailfile ( -- )	file CLOSE-FILE DROP ;P	

: pop3-init ( -- )
	server COUNT IPPORT_POP3 $OPEN-I/O [sock]
	0 SET-SOCKET-TIMEOUT  EAT-ALL ;P

: pop3-exit ( -- ) SCLOSE-I/O [sock] ;P

: authorization ( -- )
	S" USER " username COUNT $+ cmd
	S" PASS " passwd   COUNT $+ cmd ;P

: delete-it ( u -- )  S" DELE " ROT (0DEC.R) $+ cmd ;P
: pop3-quit ( -- )    S" QUIT" cmd ;P
: .emails   ( u -- )  CR ." You have " DUP DEC. ." message" ?s ."  waiting." ;P

-- This one must wait for its string to parse
: transaction ( -- #emails ) 
	S" STAT" cmd
	response$ #resp $>NUM 2NIPS
	DUP .emails ;P

: ask-for-it	 ( u -- ) S" RETR " ROT (0DEC.R) $+ cmd ;P
: (store-emails) ( u -- ) 0 ?DO   I 1+ ask-for-it  S" NEXT MESSAGE" store-it  I 1+ delete-it   LOOP ;P

: store-emails	( u -- )  
	open-mailfile
	  ['] (store-emails) CATCH ?DUP IF  close-mailfile  pop3-exit  THROW  ENDIF
	close-mailfile ;P

: pop3-loop	( xt -- ) >S authorization transaction S> EXECUTE pop3-quit ;P
: MAIL		( -- )    pop3-init  ['] store-emails  pop3-loop  pop3-exit ;
: MAIL?		( -- )    pop3-init  ['] DROP          pop3-loop  pop3-exit ;

:ABOUT		CR ." Usage: MAIL  -- get mail to " mailfile .$
		CR ."        MAIL? -- tests if there is mail." ;

                .ABOUT -mail CR
		DEPRIVE
		MAIL
					(* End of Source *)