(*
 * LANGUAGE    : ANS Forth 
 * PROJECT     : Forth Environments
 * DESCRIPTION : Smart buffers
 * CATEGORY    : Utility
 * AUTHOR      : Marcel Hendrix 
 * LAST CHANGE : Sunday, December 22, 2002 7:49 PM, MHX, split off from STREAMS
 *)



	NEEDS -miscutil

	REVISION -buffers " Buffer words        Version 1.01 "

	PRIVATES


-- Create buffers that automatically deallocate when forgotten.

USER %buf	PRIVATE

: %addr		0 %buf ! ; IMMEDIATE
: %free		1 %buf ! ; IMMEDIATE
: %get		2 %buf ! ; IMMEDIATE 
: %size		3 %buf ! ; IMMEDIATE 


: GET-BUF ( addr -- )
		DUP CELL+ @ ALLOCATE ?ALLOCATE  
		SWAP ! ;


: FREE-BUF ( addr -- )
		DUP @ SWAP OFF  
		FREE ?ALLOCATE ;

DOC
(*
 A child of :BUFFER is smart when compiled. The TO-concept is used.
 When a buffer is created, the wanted size is stored, but no allocation is
 attempted yet.

 Four messages can be send to a buffer:

  - %addr  This is the default, like FROM.  Returns start address.
  - %free  The buffer is deallocated.
  - %get   The number of bytes that were passed when created are allocated.
  - %size  The number of bytes that were passed when created 

 When a child of :BUFFER is forgotten, any memory still allocated gets freed.

 Example:
 
 256 :BUFFER buf1	( the buffer should have 256 bytes)

	%get buf1	( allocates 256 bytes)
	buf1 20 DUMP	( dumps initial contents. This will be garbage)
	%free buf1	( release the buffer)
	%size buf1 .	( prints 256)

	FORGET buf1	( would have freed the memory too)
*)
ENDDOC


: :BUFFER	CREATE	IMMEDIATE		\ <bytes> --- <>
			0 , ( size) ,
		FORGET>	FREE-BUF		\ null pointer is no problem
		DOES>	ALITERAL		\ <> --- <addr>
			%buf @  %buf OFF
			CASE 
			  0 OF EVAL" @ " 	 ENDOF
			  1 OF ['] FREE-BUF NOW? ENDOF
			  2 OF ['] GET-BUF  NOW? ENDOF
			  3 OF EVAL" CELL+ @ "	 ENDOF
			  DUP ABORT" :BUFFER : illegal action"
			ENDCASE ;



:ABOUT	CR ." -- Smart buffers, using the TO-concept." 
	CR
	CR ." <size in bytes> :BUFFER #<bufname>#"
	CR ." %get  bufname   -- allocate the buffer"
	CR ." %addr bufname   -- returns buffer start address"
	CR ." bufname         -- returns buffer start address"
	CR ." %free bufname   -- deallocates the buffer" 
	CR ." %size bufname   -- get buffer size " 
	CR ." FORGET bufname  -- forget action is to execute `%free bufname'" ;

	DEPRIVE
	nesting @ 1 = [IF] .ABOUT -buffers CR [THEN]

 			    	(* End of BUFFERS *)